#version 330
#extension GL_EXT_gpu_shader4 : enable
// Garden of SpheresMod01.fsh  by  konidia

//https://www.shadertoy.com/view/Md3Bz8
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define MAX_ITERATION 300

// top half: 25 unites high
const float height1 = 25.0;


// bottom half: 2 units high
const float height2 = 2.0;

// look around horizontally with mouse
const float radius = 0.4;

// structs

struct Ray
{
    vec3 pos;
    vec3 dir;
};

struct Camera
{
    vec3 pos;
    vec3 forward;
    vec3 right;
    vec3 up;
    float fovScalar;
};
    
// functions for casting rays
    
void setCamera(vec3 pos, vec3 forward, vec3 upGuide, float fov, out Camera cam)
{
    cam.pos = pos;
    cam.forward = normalize(forward);
    cam.right = cross(-cam.forward, normalize(upGuide));
    cam.up = cross(cam.right, -cam.forward);
    cam.fovScalar = tan(radians(fov/2.0));
}

Ray castRay(vec2 uv, in Camera cam)
{
    uv *= cam.fovScalar;
    return Ray(
        cam.pos,
        normalize(cam.forward + uv.x * cam.right + uv.y * cam.up)
    );
}

// noise function

vec3 noise(in vec2 uv){return texture2D(iChannel0, uv).rgb;}

// shape intersection functions

float iSphere(in vec3 ro, in vec3 rd, in vec4 sph)
{
	vec3 p = ro - sph.xyz;
	float b = dot( p, rd );
	float c = dot( p, p ) - sph.w*sph.w;
	float h = b*b - c;
	if( h<0.0 ) return -1.0;
	return -b - sqrt( h );
}

vec3 nSphere(in vec3 p, in vec4 sph)
{
    return (p-sph.xyz)/sph.w;
}

float iFloor(in vec3 ro, in vec3 rd, float h)
{
    if(ro.y <= h)
        return -1.;
    if(rd.y >= 0.)
        return -1.;
    
    h = h - ro.y;
    return h/rd.y;
}

// produce color based on ro and rd

vec3 rayCast(vec3 ro, vec3 rd)
{
    float t = iFloor(ro, rd, radius*2.75);
    if(t < 0.)
        return vec3(0, 0.8, 1);
    
    ro = ro + t * rd;
    
    vec3 mapPos = floor(ro);
    vec3 rayStep = sign(rd);
    vec3 deltaDist = abs(1./rd);
    vec3 sideDist = sign(rd)*(mapPos - ro + sign(rd)*0.5+0.5)*deltaDist;
    
    bvec3 mask = lessThanEqual(sideDist.xyz, min(sideDist.yxx, sideDist.zzy));
    
    for(int i = 0; i < MAX_ITERATION; ++i)
    {   
        mapPos += vec3(mask) * rayStep;
        
        vec4 sph = vec4(vec3(mapPos.x+0.5, radius, mapPos.z+0.5), radius);
        
        t = iSphere(ro, rd, sph);
        
        if(t >= 0.)
        {
            vec3 p = ro + rd * t;
            float diff = max(dot(nSphere(p, sph), vec3(0,1,0)),0.)+0.2;
            mapPos = mod(mapPos, vec3(50.));
            return diff*noise(mapPos.xz/128.);
        }
        if(mapPos.y < 0.) 
            return vec3(0.2, 0.1, 0);
        
        sideDist += vec3(mask) * deltaDist;
        
        mask = lessThanEqual(sideDist.xyz, min(sideDist.yxx, sideDist.zzy));
    }
    
    return vec3(0, 0.8, 1);
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = gl_FragCoord.xy/iResolution.xy * 2. - 1.;
    uv.y *= iResolution.y/iResolution.x;
	
    Camera cam;
    vec3 pos = vec3(0, height1+radius*2., 0.5+iTime*5.);
    float mouseX = (iMouse.x/iResolution.x-0.5)*6.28;
    vec3 dir = vec3(sin(mouseX), -0.3, cos(-mouseX));
    if(uv.y < 0.005 && uv.y > -0.005)
    {
        gl_FragColor = vec4(vec3(0), 1);
        return;
    }
    if(uv.y <= -0.005)
    {
        pos = vec3(0, height2+radius*2., 0.5+iTime*5.);
    	dir = vec3(sin(mouseX), -0.01, cos(-mouseX));
    }
    
    setCamera(pos, dir, vec3(0,1,0), 60., cam);
    Ray ray = castRay(uv, cam);

    gl_FragColor = vec4(rayCast(ray.pos, ray.dir),1.0);
}